/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.conndata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CecInfo
implements Serializable,
Comparable {
    private static final long serialVersionUID = 8433485722252247686L;
    private String type;
    private String model;
    private String serial;
    private String userName;
    private List partitions = new ArrayList();

    public CecInfo(String type, String model, String serial, String userName, List lparInfo) {
        if (type == null) {
            throw new IllegalArgumentException("Null machine type specified");
        }
        if (model == null) {
            throw new IllegalArgumentException("Null model specified");
        }
        if (serial == null) {
            throw new IllegalArgumentException("Null serial number specified");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Null user defined name specified");
        }
        if (lparInfo == null) {
            throw new IllegalArgumentException("Null logical partiton information specified");
        }
        this.type = type;
        this.model = model;
        this.serial = serial;
        this.userName = userName;
        this.partitions = lparInfo;
    }

    public String getType() {
        return this.type;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerial() {
        return this.serial;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDisplayName() {
        return this.type + "-" + this.model + "/" + this.serial;
    }

    public List getPartitions() {
        return this.partitions;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CecInfo)) {
            return false;
        }
        CecInfo cecInfo = (CecInfo)obj;
        return this.type.equals(cecInfo.type) && this.model.equals(cecInfo.model) && this.serial.equals(cecInfo.serial);
    }

    public int hashCode() {
        return this.type.hashCode() + this.model.hashCode() + this.serial.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{CecInfo ");
        sb.append("type=" + this.type + ", ");
        sb.append("model=" + this.model + ", ");
        sb.append("serial=" + this.serial + ", ");
        sb.append("userName=" + this.userName + ", ");
        sb.append("lpars=" + this.partitions.size() + "]");
        return sb.toString();
    }

    public int compareTo(Object obj) {
        return this.getDisplayName().compareTo(((CecInfo)obj).getDisplayName());
    }
}

